<?php

/*spl_autoload_register(function($clase) {
    $ruta = __DIR__ . '/../' . str_replace('\\', '/', $clase) . '.php';
    if(file_exists($ruta)) {
        require_once $ruta;
    } else {
        die("No se encuentra la clase $clase en: $ruta");
    }
});*/

spl_autoload_register(function($clase){
    // Como autoload.php está en la raíz, usar __DIR__ directamente
    $ruta = __DIR__ . '/' . str_replace('\\', '/', $clase) . ".php";
    
    if(file_exists($ruta)){
        require_once $ruta;
    } else {
        die("No se encuentra la clase $clase en la ruta: $ruta");
    }
});