<?php

/*echo "<div style='background: #f0f0f0; padding: 15px; margin: 10px; border: 2px solid #333; font-family: monospace;'>";
echo "<h2>🔍 DIAGNÓSTICO COMPLETO</h2>";

// 1. Verificar estructura de directorios
echo "<h3>1. Estructura de directorios:</h3>";
echo "Directorio actual: <strong>" . __DIR__ . "</strong><br>";
echo "Directorio padre: <strong>" . dirname(__DIR__) . "</strong><br>";
echo "Ruta esperada del .env: <strong>" . dirname(__DIR__) . '/.env' . "</strong><br>";

// 2. Verificar si el archivo .env existe
$envPath = dirname(__DIR__) . '/.env';
echo "<h3>2. Archivo .env:</h3>";
if (file_exists($envPath)) {
    echo "✅ El archivo .env EXISTE<br>";
    echo "Contenido del archivo:<br>";
    echo "<textarea style='width: 100%; height: 150px;'>" . file_get_contents($envPath) . "</textarea>";
} else {
    echo "❌ El archivo .env NO EXISTE en: " . $envPath . "<br>";
    echo "Archivos en el directorio raíz:<br>";
    $files = scandir(dirname(__DIR__));
    foreach ($files as $file) {
        if ($file !== '.' && $file !== '..') {
            echo "- " . $file . "<br>";
        }
    }
}

// 3. Verificar si Composer autoload funciona
echo "<h3>3. Composer autoload:</h3>";
$autoloadPath = dirname(__DIR__) . '/vendor/autoload.php';
if (file_exists($autoloadPath)) {
    echo "✅ Autoload existe<br>";
    require_once $autoloadPath;
    echo "✅ Autoload cargado<br>";
} else {
    echo "❌ Autoload NO existe en: " . $autoloadPath . "<br>";
}

// 4. Verificar si DotEnv está disponible
echo "<h3>4. DotEnv:</h3>";
if (class_exists('Dotenv\Dotenv')) {
    echo "✅ Clase Dotenv disponible<br>";
    
    try {
        $dotenv = Dotenv\Dotenv::createImmutable(dirname(__DIR__));
        echo "✅ Dotenv creado<br>";
        
        $dotenv->load();
        echo "✅ Dotenv->load() ejecutado<br>";
        
    } catch (Exception $e) {
        echo "❌ Error al cargar DotEnv: " . $e->getMessage() . "<br>";
    }
} else {
    echo "❌ Clase Dotenv NO disponible<br>";
}

// 5. Verificar variables de entorno después de cargar
echo "<h3>5. Variables de entorno después de cargar:</h3>";
echo "APP_ENV: <strong>" . ($_ENV['APP_ENV'] ?? 'NO DEFINIDA') . "</strong><br>";
echo "APP_DEBUG: <strong>" . ($_ENV['APP_DEBUG'] ?? 'NO DEFINIDA') . "</strong><br>";
echo "APP_URL: <strong>" . ($_ENV['APP_URL'] ?? 'NO DEFINIDA') . "</strong><br>";
echo "APP_NAME: <strong>" . ($_ENV['APP_NAME'] ?? 'NO DEFINIDA') . "</strong><br>";

// 6. Mostrar todas las variables $_ENV
echo "<h3>6. Todas las variables \$_ENV:</h3>";
if (!empty($_ENV)) {
    echo "<pre>" . print_r($_ENV, true) . "</pre>";
} else {
    echo "❌ \$_ENV está vacío<br>";
}

echo "</div>";

// Detener la ejecución aquí para el diagnóstico
exit("=== FIN DEL DIAGNÓSTICO ===");*/
// Cargar autoloader de Composer
require_once __DIR__ . '/../vendor/autoload.php';

// Cargar configuración
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';

// Configurar manejo de errores según el entorno
if (APP_ENV === 'local') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Cargar clases
use Lib\Route;

// Cargar rutas
require_once __DIR__ . '/../routes/web.php';

/*function urlImages($path) {
    return rtrim(BASE_URL, '/') . '/' . ltrim($path, '/');
}*/

function urlImages($path) {
    return  '/'.$path; // Ajusta la ruta según tu estructura
}
