var uuid = "";
document
  .getElementById("consultaForm")
  .addEventListener("submit", function (e) {
    e.preventDefault();

    const medidor = document.getElementById("medidor").value.trim();
    const documento = document.getElementById("documento").value.trim();

    if (!medidor && !documento) {
      Swal.fire({
        title: "Campos requeridos",
        text: "Debe ingresar al menos el número de medidor o documento de identidad",
        icon: "warning",
      });
      return;
    }

    const url = baseUrl + "consulta/factura";
    const $btnConsultar = $(this).find('button[type="submit"]');

    // Mostrar loading
    $btnConsultar
      .prop("disabled", true)
      .html('<i class="fas fa-spinner fa-spin me-2"></i>Consultando...');

    $.ajax({
      url: url,
      type: "GET",
      data: { medidor: medidor, documento: documento },
      dataType: "json",
      success: function (response) {
        // console.log(response);
        $btnConsultar
          .prop("disabled", false)
          .html('<i class="fas fa-search me-2"></i>Consultar');

        if (response.status === "success") {
          if (
            !medidor &&
            response.data.medidores &&
            response.data.medidores.length > 1
          ) {
            mostrarSelectMedidores(response.data.medidores, documento);
          }
          // Caso 2: Cualquier otro caso (solo medidor o ambos) - mostrar resultados
          else {
            uuid = response.data.ultima_factura.uuid;
            actualizarUI(response.data);
            document.querySelector(".resultados-section").style.display =
              "block";
            document
              .querySelector("#resultados")
              .scrollIntoView({ behavior: "smooth" });
          }
        } else {
          Swal.fire({
            title: "Atención",
            text:
              response.message || "No se encontraron datos para esta consulta",
            icon: "warning",
          });
          limpiarTabla();
        }
      },
      error: function (xhr, status, error) {
        $btnConsultar
          .prop("disabled", false)
          .html('<i class="fas fa-search me-2"></i>Consultar');
        console.error("Error en la consulta:", status, error);
        Swal.fire({
          title: "Error",
          text: "Ocurrió un error al realizar la consulta. Por favor intente nuevamente.",
          icon: "error",
        });
      },
    });
  });

// Función para mostrar select de medidores
function mostrarSelectMedidores(medidores, documento) {
  // Ocultar campo de medidor manual y mostrar el select
  $("#medidor").closest(".col-md-6").hide();
  $("#medidores-container").show();

  // Limpiar y llenar el select
  const $select = $("#select-medidor");
  $select
    .empty()
    .append(
      '<option value="" selected disabled>-- Selecciona un medidor --</option>'
    );

  medidores.forEach((medidor) => {
    $select.append(`<option value="${medidor.serie}" data-ubicacion="${medidor.ubicacion}">
                        ${medidor.serie} - ${medidor.ubicacion}
                       </option>`);
  });

  // Configurar evento para cuando se seleccione un medidor
  $select.off("change").on("change", function () {
    const medidorSeleccionado = $(this).val();
    if (medidorSeleccionado) {
      // Mostrar loading en el botón principal
      const $btnConsultar = $("#consultaForm").find('button[type="submit"]');
      $btnConsultar
        .prop("disabled", true)
        .html('<i class="fas fa-spinner fa-spin me-2"></i>Consultando...');

      // Realizar la nueva consulta con ambos campos
      $.ajax({
        url: baseUrl + "consulta/factura",
        type: "GET",
        data: {
          medidor: medidorSeleccionado,
          documento: documento,
        },
        dataType: "json",
        success: function (response) {
          $btnConsultar
            .prop("disabled", false)
            .html('<i class="fas fa-search me-2"></i>Consultar');

          if (response.status === "success") {
            uuid = response.data.ultima_factura.uuid;
            actualizarUI(response.data);
            document.querySelector(".resultados-section").style.display =
              "block";
            document
              .querySelector("#resultados")
              .scrollIntoView({ behavior: "smooth" });
          } else {
            Swal.fire({
              title: "Atención",
              text:
                response.message ||
                "No se encontraron datos para esta consulta",
              icon: "warning",
            });
            limpiarTabla();
          }
        },
        error: function (xhr, status, error) {
          $btnConsultar
            .prop("disabled", false)
            .html('<i class="fas fa-search me-2"></i>Consultar');
          console.error("Error en la consulta:", status, error);
          Swal.fire({
            title: "Error",
            text: "Ocurrió un error al realizar la consulta. Por favor intente nuevamente.",
            icon: "error",
          });
        },
      });
    }
  });
}

function limpiarTabla() {
  // Ocultar resultados
  document.querySelector(".resultados-section").style.display = "none";

  // Limpiar campos de resultados
  $("#cliente-nombre, #medidor-serie, #cliente-direccion").text("");
  $("#factura-periodo, #factura-consumo, #factura-monto, #factura-estado").text(
    ""
  );
  $("#cuenta-monto, #cuenta-estado").text("");

  // Destruir y limpiar DataTable si existe
  if ($.fn.DataTable.isDataTable("#historialFacturas")) {
    $("#historialFacturas").DataTable().destroy();
    $("#historialFacturas tbody").empty();
  }

  if ($.fn.DataTable.isDataTable("#historialMultas")) {
    $("#historialMultas").DataTable().destroy();
    $("#historialMultas tbody").empty();
  }
}
// Función para resetear el formulario si es necesario
function resetearFormularioConsulta() {
  $("#medidor").val("").closest(".col-md-6").show();
  $("#medidores-container").hide();
  $("#select-medidor").empty();
}

function actualizarUI(data) {
  // console.log(data);
  // Información del cliente
  $("#cliente-nombre").text(data.cliente.nombre);
  $("#medidor-serie").text(data.medidor.serie);
  $("#cliente-direccion").text(data.cliente.direccion);

  // Última factura
  $("#factura-periodo").text(data.ultima_factura.periodo);
  $("#factura-consumo").text(data.ultima_factura.consumo);
  $("#factura-monto").text(parseFloat(data.ultima_factura.monto).toFixed(2));
  $("#factura-estado").text(data.ultima_factura.estado || "--");

  // Estado de cuenta
  const montoPendiente = data.estado_cuenta.monto_pendiente;
  const $cuentaMonto = $("#cuenta-monto");
  const $cuentaEstado = $("#cuenta-estado");

  $cuentaMonto.text("$" + parseFloat(montoPendiente).toFixed(2));
  if (montoPendiente > 0) {
    $cuentaMonto.removeClass("text-success").addClass("text-danger");
    $cuentaEstado.html(
      '<i class="fas fa-exclamation-circle me-2 text-danger"></i>Pendiente de pago'
    );
  } else {
    $cuentaMonto.removeClass("text-danger").addClass("text-success");
    $cuentaEstado.html(
      '<i class="fas fa-check-circle me-2 text-success"></i>Al día'
    );
  }

  // Configurar DataTable para el historial
  if ($.fn.DataTable.isDataTable("#historialFacturas")) {
    $("#historialFacturas").DataTable().destroy();
  }

  $("#historialFacturas").DataTable({
    data: data.historial_facturas,
    columns: [
      {
        data: "fecha_lectura",
        render: function (data) {
          return data ? new Date(data).toLocaleDateString() : "--";
        },
      },
      { data: "lectura_anterior", defaultContent: "--" },
      {
        data: "consumo",
        render: function (data) {
          return data || "0";
        },
      },
      {
        data: "monto",
        render: function (data) {
          return data ? "$" + parseFloat(data).toFixed(2) : "$0.00";
        },
      },
      {
        data: "estado",
        render: function (data) {
          let badgeClass = "secondary";
          let estadoTexto = "Desconocido";

          if (data === 1) {
            badgeClass = "success";
            estadoTexto = "Pagado";
          } else if (data === 0) {
            badgeClass = "warning";
            estadoTexto = "Pendiente";
          } else if (data === "Vencido") {
            badgeClass = "danger";
            estadoTexto = "Vencido";
          }

          return (
            '<span class="badge bg-' +
            badgeClass +
            '">' +
            estadoTexto +
            "</span>"
          );
        },
      },
      {
        data: "uuid",
        render: function (data) {
          return (
            '<button class="btn btn-sm btn-outline-primary btn-descargar" data-id="' +
            data +
            '">' +
            '<i class="fas fa-download me-1"></i>PDF</button>'
          );
        },
        orderable: false,
      },
    ],
    language: {
      url: baseUrl + "assets/js/es-ES.json",
    },
    order: [[0, "desc"]],
    responsive: true,
  });

  if ($.fn.DataTable.isDataTable("#historialMultas")) {
    $("#historialMultas").DataTable().destroy();
  }

  $("#historialMultas").DataTable({
    data: data.historial_multas,
    columns: [
      {
        data: "fecha_reunion",
        render: function (data) {
          return data ? new Date(data).toLocaleDateString() : "--";
        },
      },
      { data: "tema_tratado", defaultContent: "--" },
      {
        data: "descripcion",
        defaultContent: "--",
      },
      {
        data: "monto",
        render: function (data) {
          return data ? "$" + parseFloat(data).toFixed(2) : "$0.00";
        },
      },
      {
        data: "estado_pago",
        render: function (data) {
          let badgeClass = "secondary";
          let estadoTexto = "Desconocido";

          if (data === 1) {
            badgeClass = "success";
            estadoTexto = "Pagado";
          } else if (data === 0) {
            badgeClass = "warning";
            estadoTexto = "Pendiente";
          } else if (data === "Vencido") {
            badgeClass = "danger";
            estadoTexto = "Vencido";
          }

          return (
            '<span class="badge bg-' +
            badgeClass +
            '">' +
            estadoTexto +
            "</span>"
          );
        },
      },
      /*{
        data: "uuid",
        render: function (data) {
          return (
            '<button class="btn btn-sm btn-outline-primary btn-descargar" data-id="' +
            data +
            '">' +
            '<i class="fas fa-download me-1"></i>PDF</button>'
          );
        },
        orderable: false,
      },*/
    ],
    language: {
      url: baseUrl + "assets/js/es-ES.json",
    },
    order: [[0, "desc"]],
    responsive: true,
  });

  // Evento para botón de descargar PDF
  $(document).on("click", ".btn-descargar", function () {
    const facturaId = $(this).data("id");
    window.open(baseUrl + "facturas/descargar/" + facturaId, "_blank");
    // window.open(baseUrl + 'report-voucher/ticket/' + facturaId, '_blank');
  });

  // Evento para botón de pago en línea
  $("#pagar-en-linea").click(function () {
    if (montoPendiente > 0) {
      window.location.href = baseUrl + "pagos/realizar";
    } else {
      Swal.fire({
        title: "'No tiene pagos pendientes",
        //text: 'Ocurrió un error al realizar la consulta. Por favor intente nuevamente.',
        icon: "info",
      });
    }
  });

  // Evento para botón de descargar última factura
  $("#descargar-pdf").click(function () {
    window.open(baseUrl + "facturas/descargar/" + uuid, "_blank");
  });
}

// Función para limpiar todo el formulario y resultados
function limpiarConsulta() {
  // Resetear campos del formulario
  document.getElementById("consultaForm").reset();

  // Ocultar resultados
  document.querySelector(".resultados-section").style.display = "none";

  // Limpiar campos de resultados
  $("#cliente-nombre, #medidor-serie, #cliente-direccion").text("");
  $("#factura-periodo, #factura-consumo, #factura-monto, #factura-estado").text(
    ""
  );
  $("#cuenta-monto, #cuenta-estado").text("");

  // Destruir y limpiar DataTable si existe
  if ($.fn.DataTable.isDataTable("#historialFacturas")) {
    $("#historialFacturas").DataTable().destroy();
    $("#historialFacturas tbody").empty();
  }

  if ($.fn.DataTable.isDataTable("#historialMultas")) {
    $("#historialMultas").DataTable().destroy();
    $("#historialMultas tbody").empty();
  }

  // Resetear el selector de medidores (si estaba visible)
  resetearFormularioConsulta();

  // Enfocar el primer campo
  document.getElementById("medidor").focus();
}

// Asignar evento al botón "Limpiar"
document
  .getElementById("btn-limpiar")
  .addEventListener("click", limpiarConsulta);
