"use strict";
var tabla;

//funcion que se ejecuta al inicio
function init() {
  mostrarAjustes();
	$("#detallesEliminados").hide();
  mostrarform(false);
  listar();

  $("#formulario").on("submit", function (e) {
    guardaryeditar(e);
  });


}

//funcion limpiar
function limpiar() {
  $("#id").val("");
  $("#idMedidor").val("");
  $("#series").val("");
  $("#cliente").val("");
  $("#previus_reading").val("");
  $("#last_reading").val("");
  $("#consumption").val("");
  $("#total_cost").val("");

}

//funcion mostrar formulario
function mostrarform(flag) {
  limpiar();
  if (flag) {
    $("#listadoregistros").hide();
    $("#formularioregistros").show();
    $("#btnGuardar").prop("disabled", false);
    $("#btnagregar").hide();
  } else {
    $("#listadoregistros").show();
    $("#formularioregistros").hide();
    $("#btnagregar").show();
  }
}

//cancelar form
function cancelarform() {
  limpiar();
  mostrarform(false);
}

//funcion listar
function listar() {
  tabla = $("#tbllistado")
    .dataTable({
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        thousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
      aProcessing: true, //activamos el procedimiento del datatable
      aServerSide: true, //paginacion y filrado realizados por el server
      dom: "Bfrtip", //definimos los elementos del control de la tabla
      buttons: [
        {
          extend: "excelHtml5",
          text: '<i class="fa fa-file-excel-o"></i> Excel',
          titleAttr: "Exportar a Excel",
          title: "Reporte de Reparaciones",
          sheetName: "Reparaciones",
          exportOptions: {
            columns: [0, 1, 2,3,4,5,6],
          },
        },
        {
          extend: "pdfHtml5",
          text: '<i class="fa fa-file-pdf-o"></i> PDF',
          titleAttr: "Exportar a PDF",
          title: "Reporte de Reparaciones",
          //messageTop: "Reporte de reparaciones",
          pageSize: "A4",
          //orientation: 'landscape',
          exportOptions: {
            columns: [0, 1, 2,3,4,5,6],
          },
        },
      ],
      ajax: {
        url: baseUrl+"meter-reading/listar",
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      iDisplayLength: 10, //paginacion
      order: [[6, "desc"]], //ordenar (columna, orden)
    })
    .DataTable();
}
//funcion para guardaryeditar
function guardaryeditar(e) {
  e.preventDefault(); //no se activara la accion predeterminada
  $("#btnGuardar").prop("disabled", true);
  var formData = new FormData($("#formulario")[0]);

  $.ajax({
    url: "meter-reading/guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,

    success: function (datos) {
      var tabla = $("#tbllistado").DataTable();
      Swal.fire({
        title: "Registro",
        text: datos,
        icon: "info",
        buttons: {
          confirm: "OK",
        },
      }),
        mostrarform(false);
      tabla.ajax.reload();
    },
  });

  limpiar();
}

function mostrar(id) {
  $.post(
    "meter-reading/mostrar",
    { id: id },
    function (data, status) {
      data = JSON.parse(data);
      mostrarform(true);

      $("#id").val(data.id);
      $("#idMedidor").val(data.meter_id);
      if (data.previus_reading == 0) {
        // Si la lectura previa es 0, permite la edición del campo de entrada
        $("#previus_reading").prop("readonly", false); 
    } else {
        // Si la lectura previa no es 0, hace que el campo de entrada sea de solo lectura
        $("#previus_reading").prop("readonly", true);
    }
      $("#previus_reading").val(data.previus_reading);
      $("#last_reading").val(data.last_reading); 

      $("#total_cost").val(data.total_cost);
      $("#type").val(data.type);


    }
  );

}


//funcion para mostrar formulario paa agregar nuevo cliente
function verMedidores() {
	$("#mdlclientes").modal("show");
    listarClientes();
}

function listarClientes() {
	tabla = $("#tblclientes")
		.dataTable({
			language: {
				decimal: "",
				emptyTable: "No hay información",
				info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
				infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
				infoFiltered: "(Filtrado de _MAX_ total entradas)",
				infoPostFix: "",
				thousands: ",",
				lengthMenu: "Mostrar _MENU_ Entradas",
				loadingRecords: "Cargando...",
				processing: "Procesando...",
				search: "Buscar:",
				zeroRecords: "Sin resultados encontrados",
				paginate: {
					first: "Primero",
					last: "Ultimo",
					next: "Siguiente",
					previous: "Anterior",
				},
			},
			aProcessing: true, //activamos el procedimiento del datatable
			aServerSide: true, //paginacion y filrado realizados por el server
			dom: "Bfrtip", //definimos los elementos del control de la tabla
			buttons: [],
			ajax: {
				url: "meters/listaReading",
				type: "get",
				dataType: "json",
				error: function (e) {
					console.log(e.responseText);
				},
			},
			bDestroy: true,
			iDisplayLength: 5, //paginacion
			order: [[0, "desc"]], //ordenar (columna, orden)
		})
		.DataTable();
}

function agregarCliente(id,serie,last_reading,cliente,client_id) {
	limpiar();
	$("#idMedidor").val(id);
  if (last_reading == 0) {
    // Si la lectura previa es 0, permite la edición del campo de entrada
    $("#previus_reading").prop("readonly", false); 
} else {
    // Si la lectura previa no es 0, hace que el campo de entrada sea de solo lectura
    $("#previus_reading").prop("readonly", true);
}
	$("#previus_reading").val(last_reading);
	$("#series").val(serie);
	$("#cliente").val(cliente);
	$("#client_id").val(client_id);
}


var max_cubic = 0;
var cost_water = 0;
var price_cubic = 0;
var total_cost = 0;
var consumption = 0;
var plus = 0;
var costMeter = 1;

$("#last_reading").change(function() {
  calcularConsumo();
});

$("#type").change(function() {
  calcularConsumo();
});


function mostrarAjustes() {
  $.get("company/mostrar", function(data, status) {
      data = JSON.parse(data);
      max_cubic = parseFloat(data.max_cubic);
      cost_water = parseFloat(data.cost_water);
      price_cubic = parseFloat(data.price_cubic);
      $("#max_cubico").text(max_cubic);
      $("#precio_fijo").text(cost_water);
      $("#precio_cubico").text(price_cubic);
  });
}

function calcularConsumo() {
  var typeMeter = $("#type").val();
  var adjustedMaxCubic = max_cubic;
  var adjustedCostWater = cost_water;

  if (typeMeter === 'Bimestral') {
      adjustedMaxCubic = max_cubic * 2;
      costMeter = 2;
  } else if (typeMeter === 'Trimestral') {
      adjustedMaxCubic = max_cubic * 3;
      costMeter = 3;
  } else {
      costMeter = 1;
  }

  $("#max_cubico").text(adjustedMaxCubic);

  var now_reading = parseFloat($("#last_reading").val());
  var previus_reading = parseFloat($("#previus_reading").val());

  if (isNaN(now_reading) || isNaN(previus_reading) || now_reading <= previus_reading) {
      Swal.fire(
          'Error',
          "Ingrese valores válidos y asegúrese de que la lectura actual sea mayor que la anterior.",
          "error"
      );
      $("#last_reading").val("");
      return;
  }

  consumption = now_reading - previus_reading;
  $("#consumption").val(consumption);

  if (consumption > adjustedMaxCubic) {
      plus = consumption - adjustedMaxCubic;
      total_cost = (adjustedCostWater * costMeter) + (plus * price_cubic);
  } else {
      total_cost = adjustedCostWater * costMeter;
  }

  $("#total_cost").val(total_cost.toFixed(2));
}
init();
