<?php

use Lib\Route;
use App\Controllers\AttendanceController;
use App\Controllers\AuthController;
use App\Controllers\CompanyController;
use App\Controllers\CustomerController;
use App\Controllers\ExpenseController;
use App\Controllers\FrontController;
use App\Controllers\HomeController;
use App\Controllers\IncomeController;
use App\Controllers\MeetingController;
use App\Controllers\MeterController;
use App\Controllers\PaymentController;
use App\Controllers\ReadingController;
use App\Controllers\ReportController;
use App\Controllers\UserController;
use App\Controllers\ZoneController;
use App\Middleware\AuthMiddleware;

// Rutas públicas (no requieren autenticación)

// Ruta para autenticación
Route::get('/', [FrontController::class, 'index']);
Route::get('/consulta', [FrontController::class, 'consulta']);
//consulta
Route::get('/consulta/factura',[FrontController::class,'consultaFactura']);
Route::get('/facturas/descargar/{uuid}',[ReportController::class,'imprimirFactura']);

Route::get('/login', [AuthController::class, 'login']); // Muestra el formulario de inicio de sesión
Route::post('/authenticate', [AuthController::class, 'authenticate']); // Maneja el inicio de sesión
Route::get('/logout', [AuthController::class, 'logout']); // Cierra la sesión

// Rutas protegidas (requieren autenticación con el middleware)
//dashboar
Route::get('/dashboard', [HomeController::class,'dashboard'],[AuthMiddleware::class]);
Route::get('/dashboard/cuadros1', [HomeController::class,'cuadros1'],[AuthMiddleware::class]);
Route::get('/dashboard/ingresos12meses', [HomeController::class,'ingresos12meses'],[AuthMiddleware::class]);
Route::get('/dashboard/egresos12meses', [HomeController::class,'egresos12meses'],[AuthMiddleware::class]);

//lecturas
Route::get('/meter-reading',[ReadingController::class,'index'],[AuthMiddleware::class]);
Route::get('/meter-reading/create',[ReadingController::class,'create'],[AuthMiddleware::class]);
Route::get('/meter-reading/search/meter',[ReadingController::class,'searchMeter'],[AuthMiddleware::class]);
Route::get('/meter-reading/listar',[ReadingController::class,'listar'],[AuthMiddleware::class]);
Route::post('/meter-reading/mostrar', [ReadingController::class,'mostrar'],[AuthMiddleware::class]);
Route::post('/meter-reading/guardaryeditar', [ReadingController::class,'guardaryeditar'],[AuthMiddleware::class]);

//company
Route::get('/company/mostrar',[CompanyController::class,'mostrar'],[AuthMiddleware::class]);
Route::get('/company-setting',[CompanyController::class,'setting'],[AuthMiddleware::class]);
Route::post('/company-setting/guardaryeditar',[CompanyController::class,'guardaryeditar'],[AuthMiddleware::class]);

//medidores
Route::get('/meters',[MeterController::class,'index'],[AuthMiddleware::class]);
Route::get('/meters/listar',[MeterController::class,'listar'],[AuthMiddleware::class]);
Route::post('/meters/mostrar',[MeterController::class,'mostrar'],[AuthMiddleware::class]);
Route::post('/meters/guardaryeditar',[MeterController::class,'guardaryeditar'],[AuthMiddleware::class]);
Route::get('/meters/listaReading',[MeterController::class,'listaReading'],[AuthMiddleware::class]);
Route::get('/meters/selectMeter',[MeterController::class,'selectMeter'],[AuthMiddleware::class]);

//clientes
Route::get('/customers',[CustomerController::class,'index'],[AuthMiddleware::class]);
Route::get('/customers/listar',[CustomerController::class,'listar'],[AuthMiddleware::class]);
Route::post('/customers/mostrar',[CustomerController::class,'mostrar'],[AuthMiddleware::class]);
Route::post('/customers/guardaryeditar',[CustomerController::class,'guardaryeditar'],[AuthMiddleware::class]);
Route::post('/customers/selectClient',[CustomerController::class,'selectClient'],[AuthMiddleware::class]);
Route::post('/search/client/payment',[CustomerController::class,'searchClient'],[AuthMiddleware::class]);

//zonas
Route::get('/zones',[ZoneController::class,'index'],[AuthMiddleware::class]);
Route::get('/zones/listar',[ZoneController::class,'listar'],[AuthMiddleware::class]);
Route::get('/zones/selectZone',[ZoneController::class,'selectZone'],[AuthMiddleware::class]);
Route::post('/zones/mostrar',[ZoneController::class,'mostrar'],[AuthMiddleware::class]);
Route::post('/zones/guardaryeditar',[ZoneController::class,'guardaryeditar'],[AuthMiddleware::class]);

//gastos
Route::get('/expenses',[ExpenseController::class,'index'],[AuthMiddleware::class]);
Route::get('/expenses/listar',[ExpenseController::class,'listar'],[AuthMiddleware::class]);
Route::post('/expenses/mostrar',[ExpenseController::class,'mostrar'],[AuthMiddleware::class]);
Route::post('/expenses/guardaryeditar',[ExpenseController::class,'guardaryeditar'],[AuthMiddleware::class]);

//ingresos
Route::get('/incomes',[IncomeController::class,'index'],[AuthMiddleware::class]);
Route::get('/incomes/listar',[IncomeController::class,'listar'],[AuthMiddleware::class]);
Route::post('/incomes/mostrar',[IncomeController::class,'mostrar'],[AuthMiddleware::class]);
Route::post('/incomes/guardaryeditar',[IncomeController::class,'guardaryeditar'],[AuthMiddleware::class]);

//reuniones
Route::get('/meetings',[MeetingController::class,'index'],[AuthMiddleware::class]);
Route::get('/meetings/listar',[MeetingController::class,'listar'],[AuthMiddleware::class]);
Route::post('/meetings/mostrar',[MeetingController::class,'mostrar'],[AuthMiddleware::class]);
Route::post('/meetings/guardaryeditar',[MeetingController::class,'guardaryeditar'],[AuthMiddleware::class]);
Route::post('/meetings/activar',[MeetingController::class,'activar'],[AuthMiddleware::class]);
Route::post('/meetings/desactivar',[MeetingController::class,'desactivar'],[AuthMiddleware::class]);

//asistencias
Route::post('/attendances/register/qr',[AttendanceController::class,'registerQr'],[AuthMiddleware::class]);
Route::post('/attendances/listar',[AttendanceController::class,'listar'],[AuthMiddleware::class]);
Route::post('/attendances/registrar',[AttendanceController::class,'registrar'],[AuthMiddleware::class]);
Route::post('/attendances/register-all',[AttendanceController::class,'registerAll'],[AuthMiddleware::class]);
Route::get('/attendances/{id}',[AttendanceController::class,'index'],[AuthMiddleware::class]);

//pagos
Route::get('/payments',[PaymentController::class,'index'],[AuthMiddleware::class]);
Route::get('/payments/listar',[PaymentController::class,'listar'],[AuthMiddleware::class]);
Route::post('/payments/anular',[PaymentController::class,'anular'],[AuthMiddleware::class]);
Route::post('/payments/listarLecturas',[PaymentController::class,'listarLecturas'],[AuthMiddleware::class]);
Route::post('/payments/guardaryeditar',[PaymentController::class,'guardaryeditar'],[AuthMiddleware::class]);
Route::post('/payments/selectCliente',[PaymentController::class,'selectCliente'],[AuthMiddleware::class]);

//registro de pagos
Route::get('/payment-register',[PaymentController::class,'paymentRegister'],[AuthMiddleware::class]);
//Route::get('/producto/{id}', [PersonController::class,'show'], [AuthMiddleware::class]);
//users
Route::get('/users',[UserController::class,'index'],[AuthMiddleware::class]);
Route::get('/users/listar',[UserController::class,'listar'],[AuthMiddleware::class]);
Route::post('/users/mostrar',[UserController::class,'mostrar'],[AuthMiddleware::class]);
Route::post('/users/permisos',[UserController::class,'permisos'],[AuthMiddleware::class]);
Route::post('/users/guardaryeditar',[UserController::class,'guardaryeditar'],[AuthMiddleware::class]);
Route::post('/users/editar_clave',[UserController::class,'editar_clave'],[AuthMiddleware::class]);
Route::post('/users/desactivar',[UserController::class,'desactivar'],[AuthMiddleware::class]);
Route::post('/users/activar',[UserController::class,'activar'],[AuthMiddleware::class]);

//perfil
Route::get('/profile',[UserController::class,'profile'],[AuthMiddleware::class]);
Route::post('/profile/editarPerfil',[UserController::class,'editarPerfil'],[AuthMiddleware::class]);

//reportes
Route::get('/report-payments-date',[ReportController::class,'index'],[AuthMiddleware::class]);
Route::get('/report-payments-date/listar',[ReportController::class,'pagosfechacliente'],[AuthMiddleware::class]);
Route::get('/report-voucher/ticket/{id}',[ReportController::class,'mostrarTicket'],[AuthMiddleware::class]);
Route::get('/report-meter/qr/{code}',[ReportController::class,'mostrarQrCuadrado'],[AuthMiddleware::class]);
Route::get('/report-meter/qr-generate',[ReportController::class,'generarQrList'],[AuthMiddleware::class]);
Route::get('/report-customer/qr/{code}',[ReportController::class,'mostrarQrCuadradoCustomer'],[AuthMiddleware::class]);
// Despachar la solicitud
Lib\Route::dispatch();
