<?php

namespace App\Controllers;

use App\Models\Company;
use App\Models\User;

class AuthController extends Controller
{
    // Muestra el formulario de inicio de sesión
    public function login()
    {
        // Verificar si hay una sesión activa
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        
        // Si el usuario ya está autenticado, redirigir al dashboard
        if (isset($_SESSION['idusuario']) && $_SESSION['idusuario'] > 0) {
            header("Location: /dashboard");
            exit();
        }

        return $this->view('auth.login', ['title'=>'Inicio'], 'guest');
    }

    public function authenticate()
    {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
        
        // Obtener las credenciales
        $logina = isset($_POST["nombre"]) ? trim($_POST["nombre"]) : "";
        $clavea = isset($_POST["clave"]) ? trim($_POST["clave"]) : "";

        //Hash SHA256 en la contraseña
        $clavehash = hash("SHA256", $clavea);
        $user = new User;
        $rspta = $user->verificar($logina, $clavehash);

        if ($rspta) {
            // Declaramos las variables de sesión
            $_SESSION['idusuario'] = $rspta['idusuario'];
            $_SESSION['nombre'] = $rspta['nombre'];
            $_SESSION['imagen'] = $rspta['imagen'];
            $_SESSION['login'] = $rspta['login'];
            $_SESSION['cargo'] = $rspta['cargo'];
            $_SESSION['telefono'] = $rspta['telefono'];
            $_SESSION['email'] = $rspta['email'];
            $_SESSION['direccion'] = $rspta['direccion'];
            $_SESSION['zone_id'] = $rspta['zone_id']??'0';

            // Obtenemos los permisos
            $marcados = $user->listarmarcados($rspta['idusuario']);

            // Declaramos el array para almacenar todos los permisos
            $valores = array_column($marcados, 'idpermiso');

            // Almacenamos los permisos marcados en el array
            $_SESSION['permisos'] = []; // Inicializamos el array de permisos

            // Definimos los permisos que queremos verificar
            $permisosPermitidos = [
                1 => 'escritorio',
                2 => 'lecturas',
                3 => 'pagos',
                4 => 'clientes',
                5 => 'medidores',
                6 => 'zonas',
                7 => 'finanzas',
                8 => 'usuarios',
                9 => 'configuracion',
                10 => 'reporte_de_pagos',
                11 => 'reporte_de_egresos',
                13 => 'reuniones'
            ];

            // Asignamos los permisos a la sesión
            foreach ($permisosPermitidos as $id => $permiso) {
                $_SESSION[$permiso] = in_array($id, $valores) ? 1 : 0;
            }

            $company = new Company();
            $rsptan = $company->listar();
            $regn = $rsptan[0];
            $_SESSION['nombreEmrpesa'] = $regn['nombre'];
            $_SESSION['logoEmrpesa'] = $regn['logo'];
            
            echo json_encode(['success' => true, 'redirect' => '/dashboard']);
        } else {
            // Devolver respuesta JSON indicando error
            echo json_encode(['success' => false, 'message' => 'Credenciales inválidas']);
        }
    }

    // Cierra la sesión del usuario
    public function logout()
    {
        session_start(); // Iniciar la sesión para poder destruirla
        session_unset(); // Destruir todas las variables de sesión
        session_destroy(); // Destruir la sesión

        header("Location: /login"); // Redirigir a la página de inicio de sesión
        exit();
    }
}