<?php

namespace App\Controllers;

use App\Models\Reading;

class ReadingController extends Controller
{
	private $reading;
	public function __construct()
	{
		$this->reading = new Reading();
	}
	
	public function index()
	{
		return $this->view('readings.index', ['title' => 'Lecturas']);
	}

		public function create(){
			return $this->view('readings.create', ['title' => 'Agregar Lectura']);
		
	}

	public function guardaryeditar()
	{
		$id = $_POST["id"] ?? "";
		$meter_id = $_POST["idMedidor"] ?? "";
		$previus_reading = $_POST["previus_reading"] ?? "";
		$last_reading = $_POST["last_reading"] ?? "";
		$consumption = $_POST["consumption"] ?? "";
		$total_cost = $_POST["total_cost"] ?? "";
		$type = $_POST["type"] ?? "";
		$client_id = $_POST["client_id"] ?? "";
		$date= date('Y-m-d');

		if (empty($id)) {
			$rspta = $this->reading->insertar($meter_id, $previus_reading, $last_reading, $consumption, $total_cost, $type,$date,$client_id);
			echo $rspta ? "Datos registrados correctamente" : "No se pudo registrar los datos";
		} else {
			$rspta = $this->reading->editar($id, $meter_id, $previus_reading, $last_reading, $consumption, $total_cost, $type,$client_id);
			echo $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
		}
	}


	public function mostrar()
	{
		$id = $_POST["id"] ?? "";
		$rspta = $this->reading->mostrar($id);
		return json_encode($rspta);
	}

	public function listar()
	{
		$zoneId = null;
		if($_SESSION['zone_id']){
			$zoneId = $_SESSION['zone_id'];
		}
		$rspta = $this->reading->listar($zoneId);
		$data = array();


		foreach ($rspta as $reg) {
			$data[] = array(
				"0" => ($reg['status']) ? '<button class="btn btn-primary btn-sm" ><i class="fas fa-check"></i></button>'  : '<button class="btn btn-warning btn-sm" onclick="mostrar(' . $reg['id'] . ')"><i class="fas fa-pencil-alt"></i></button>',
				"1" => $reg['series'],
				"2" => $reg['consumption'],
				"3" => $reg['last_reading'],
				"4" => $reg['total_cost'],
				"5" => $reg['type'],
				"6" => $reg['created_at'],
				"7" => $reg['status']  ? '<span class="badge bg-success">Pagado</span>' : '<span class="badge bg-warning">Pendiente</span>',
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		return json_encode($results);
	}

public function searchMeter()
{
    $codigo = trim($_REQUEST["codigo"] ?? '');
    $data = $this->reading->searchMeter($codigo);
    
    // Verificar si hay datos
    if ($data && !empty($data)) {
        // Si hay datos, devolver success true con los datos
        $response = [
            'success' => true,
            'data' => $data
        ];
    } else {
        // Si no hay datos, devolver success false
        $response = [
            'success' => false,
            'message' => 'Medidor no encontrado'
        ];
    }
    
    //header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}
}
