<?php

namespace Lib;

class Route
{
    private static $routes = [];
    private static $middleware = [];

    public static function get($uri, $callback, $middleware = [])
    {
        $uri = trim($uri, '/');
        self::$routes['GET'][$uri] = [
            'callback' => $callback,
            'middleware' => $middleware
        ];
    }

    public static function post($uri, $callback, $middleware = [])
    {
        $uri = trim($uri, '/');
        self::$routes['POST'][$uri] = [
            'callback' => $callback,
            'middleware' => $middleware
        ];
    }

    public static function dispatch()
    {

        // Obtener la URI sin los parámetros de consulta
        $uri = $_SERVER['REQUEST_URI'];
        $uri = trim(strtok($_SERVER["REQUEST_URI"], '?'), '/');
       // $uri = trim(parse_url($uri, PHP_URL_PATH), '/'); // Extraer solo la ruta, ignorando los parámetros

        $method = $_SERVER['REQUEST_METHOD'];

        // Verificar si hay rutas registradas para el método actual
        if (!isset(self::$routes[$method])) {
            echo "404 - Método no permitido\n";
            return;
        }

        $routeFound = false; // Variable para verificar si se encontró la ruta

        foreach (self::$routes[$method] as $route => $data) {
            $callback = $data['callback'];
            $routeMiddleware = $data['middleware'];
    // Convertir la ruta a un patrón regex solo si contiene llaves
    if (strpos($route, '{') !== false) {
        $pattern = preg_replace('/\{[a-zA-Z0-9_]+\}/', '([a-zA-Z0-9_]+)', $route);
    } else {
        // Si no hay llaves, busca coincidencia exacta
        $pattern = '^' . preg_quote($route) . '$';
    }
            // Convertir la ruta a un patrón regex para capturar parámetros
            //$pattern = preg_replace('/\{[a-zA-Z0-9_]+\}/', '([a-zA-Z0-9_]+)', $route);

            if (preg_match('#^' . $pattern . '$#', $uri, $matches)) {
                //var_dump($matches);
                $params = array_slice($matches, 1); // Captura los parámetros

                // Ejecutar el middleware específico para la ruta antes del callback
                foreach ($routeMiddleware as $middlewareClass) {
                    if (class_exists($middlewareClass)) {
                        $middlewareInstance = new $middlewareClass();
                        if (method_exists($middlewareInstance, 'handle')) {
                            // Llama al método handle del middleware
                            $middlewareInstance->handle(function () use ($callback, $params) {
                                return is_callable($callback) ?
                                    $callback(...$params) :
                                    null; // Puedes agregar más lógica aquí si es necesario
                            });
                        }
                    }
                }

                // Ejecutar el callback
                if (is_callable($callback)) {
                    $response = $callback(...$params);
                } elseif (is_array($callback) && count($callback) === 2) {
                    // Manejo de controlador y método
                    [$controllerName, $methodName] = $callback;

                    // Asegúrate de que el controlador existe
                    if (class_exists($controllerName)) {
                        $controller = new $controllerName();
                        if (method_exists($controller, $methodName)) {
                           // $response = $controller->{$methodName}(...$params);
                            if (!empty($params)) {
                                $response = call_user_func_array([$controller, $methodName], $params);
                            } else {
                                $response = $controller->{$methodName}();
                            }
                        } else {
                            include "../resources/views/errors/404.php"; // Asegúrate de tener este archivo
                            return;
                            /*echo "404 - Método no encontrado\n";
                            return;*/
                        }
                    } else {
                        echo "404 - Controlador no encontrado\n";
                        return;
                    }
                } else {
                    echo "404 - Callback no válido\n";
                    return;
                }

                // Manejo de la respuesta
                if (is_array($response) || is_object($response)) {
                    header('Content-Type: application/json');
                    echo json_encode($response);
                } else {
                    echo $response;
                }

                $routeFound = true; // Ruta encontrada
                break; // Salir del bucle una vez que se encuentra la ruta
            }
        }

        // Si no se encontró ninguna ruta coincidente, mostrar vista 404
        if (!$routeFound) {
            include "../resources/views/errors/404.php"; // Asegúrate de tener este archivo
            return;
        }
    }

    public static function routeName()
    {
        //return trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
        $path = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$rutas = explode('/', $path);
$primeraRuta = reset($rutas);
return $primeraRuta;
    }

    public static function isRoute($route)
    {
        $currentUri = self::routeName();
        $pattern = preg_replace('/\{[a-zA-Z0-9_]+\}/', '([a-zA-Z0-9_]+)', $route);

        if (preg_match('#^' . $pattern . '$#', $currentUri)) {
            return true;
        }

        return false;
    }
}
