$("#formAcceso").on("submit", function (e) {
  e.preventDefault(); // Evitar el envío normal del formulario

  var nombre = $("#nombre").val();
  var clave = $("#clave").val();

  // Validar que todos los campos estén llenos
  if (nombre === "" || clave === "") {
    Swal.fire({
      title: "Error",
      text: "Asegúrate de llenar todos los campos",
      icon: "error"
    });
  } else {
    // Enviar la solicitud POST a la ruta de autenticación
    $.post(
      "/authenticate", // Cambia esto a la ruta correcta
      { nombre: nombre, clave: clave },
      function (data) {
        data = JSON.parse(data);

        // Aquí asumimos que el servidor devuelve un JSON
        if (data.success) {
          // Redirigir a la ruta principal si el inicio de sesión es exitoso
          $(location).attr("href", data.redirect); // Redirigir a la URL devuelta por el servidor
        } else {
          Swal.fire({
            title: "Error",
            text: data.message || "Usuario y/o clave incorrectos",
            icon: "error",
          });
          // Mostrar error si las credenciales son incorrectas
        }
      }
    ).fail(function(jqXHR) {
      // Manejar errores en la solicitud AJAX
      Swal.fire({
        title: "Error",
        text: "Hubo un problema al procesar tu solicitud.",
        icon: "error",
      });
    });
  }
});