"use strict";
var tabla;

function init() {

	$("#formulario").on("submit", function (e) {
		guardaryeditar(e);
	});


	var now = new Date();
	var day = ("0" + now.getDate()).slice(-2);
	var month = ("0" + (now.getMonth() + 1)).slice(-2);
	var today = now.getFullYear() + "-" + month + "-" + day;
	$("#date").val(today);

	$("#t_pago").hide();
}

//funcion limpiar
function limpiar() {
	$("#id").val("");
	$("#idcliente").val("");
	$("#transfer_number").val("");

	$("#amount").val("");
	$("#total_venta").val("");
	$(".filas").remove();
	$("#total").html("0");
	$("#most_total").html("0");
	$("#buscarCliente").val("");

}

function ShowTipopago() {
	var t_pago = $("#type").val();
	if (t_pago == "Pago en efectivo" || t_pago == "Efectivo") {
		$("#t_pago").hide();
		$("#t_adelanto").hide();
		$("#transfer_number").val("");

	} else if(t_pago == "Transferencia"){
		$("#t_pago").show();
		$("#t_adelanto").hide();
		$("#transfer_number").val("");
		$("#titulo_tipo_pago").html("N° Comprobante:");
	} else {
		$("#t_pago").show();
		$("#t_adelanto").hide();
		$("#transfer_number").val("");
		$("#titulo_tipo_pago").html("N° Operacion:");
		
	}
}

var cont = 0;
var detalles = 0;
$("#btnGuardar").hide();

//_______________________________________________________________________________________________

function listarLecturas(meter_id) {
	//var meter_id = $("#idcliente").val();
	tabla = $("#tblquantity_literss")
		.dataTable({
			language: {
				decimal: "",
				emptyTable: "No hay información",
				info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
				infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
				infoFiltered: "(Filtrado de _MAX_ total entradas)",
				infoPostFix: "",
				thousands: ",",
				lengthMenu: "Mostrar _MENU_ Entradas",
				loadingRecords: "Cargando...",
				processing: "Procesando...",
				search: "Buscar:",
				zeroRecords: "Sin resultados encontrados",
				paginate: {
					first: "Primero",
					last: "Ultimo",
					next: "Siguiente",
					previous: "Anterior",
				},
			},
			aProcessing: true, 
			aServerSide: true,
			dom: "Bfrtip", 
			buttons: [],
			ajax: {
				url: "payments/listarLecturas",
				data:{meter_id:meter_id},
				type: "post",
				dataType: "json",
				error: function (e) {
					console.log(e.responseText);
				},
			},
			bDestroy: true,
			iDisplayLength: 10, //paginacion
			order: [[0, "desc"]], //ordenar (columna, orden)
		})
		.DataTable();
	//alert( 'Rows '+tabla.rows( '.selected' ).count()+' are selected' );
} 
//funcion para guardaryeditar
function guardaryeditar(e) {
	e.preventDefault();
	//$("#btnGuardar").prop("disabled",true);
	var formData = new FormData($("#formulario")[0]);

	$.ajax({
		url: "payments/guardaryeditar",
		type: "POST",
		data: formData,
		contentType: false,
		processData: false,

		success: function (data) {
			//console.log(data);
			data = JSON.parse(data);
			
			var tabla = $("#tbllistado").DataTable();

			Swal.fire({
				title: "Registro",
				text: data.mensaje,
				//showDenyButton: true,
				showCancelButton: true,
				confirmButtonText: "Imprimir Ticket",
				cancelButtonText: "Cancelar" 
			  }).then((result) => {
				/* Read more about isConfirmed, isDenied below */
				if (result.isConfirmed) {
					window.open('report-voucher/ticket/' + data.idPayment, '_blank');
				} /*else if (result.isDenied) {
					window.open('Reports/exFactura.php?id=' + data.idPayment, '_blank');
				}*/
			  });

			tabla.ajax.reload();
		},
	});
	//init();
	limpiar();
	listarLecturas();
	evaluar();
}


function agregarDetalle(payment_id, date, description, amount) {
    if (payment_id !== "") {
        var subtotal = amount;
        var fila = 
            '<tr class="filas" id="fila' + cont + '">' +
                '<td class="" style="width: 20px;">' +
                    '<button type="button" id="del" class="btn btn-danger btn-sm del" onclick="eliminarDetalle(' + cont + ')">' +
                        '<i class="fas fa-times"></i>' +
                    '</button>' +
                '</td>' +
                '<td class="col-xs-6">' +
                    '<input style="width: 70px;" type="hidden" name="amount_cost[]" value="' + amount + '"><input style="width: 70px;" type="hidden" name="payment_id[]" value="' + payment_id + '">' + 
                    description +
                '</td>' +
                '<td class="col-xs-1">' + amount + '</td>' +
                '<td class="col-xs-1">' +
                    '<span id="subtotal' + cont + '" name="subtotal">' + subtotal + '</span>' +
                '</td>' +
            '</tr>';

        cont++;
        detalles++;
        $("#detalles").append(fila);
        modificarSubtotales();
    } else {
        alert("Error al ingresar el detalle, revisar los datos de quantity_liters");
    }
}


//borrar filas del datables
function borrar_filas() {
	// Habilitar todos los botones
	$('#tblquantity_literss tbody tr #addetalle').prop("disabled", false);

	// Obtener todos los valores de los input[name="payment_id[]"]
	const valores = $('input[name="payment_id[]"]').map(function () {
		return this.value;
	}).get();

	$('#tblquantity_literss tbody tr').each(function () {
		const boton = $(this).find('#addetalle');
		const nombre = boton.attr("name");

		if (valores.includes(nombre)) {
			boton.prop("disabled", true);
		}
	});
}



function modificarSubtotales() {
    var cant = document.getElementsByName("meter_id[]");
    var sub = document.getElementsByName("subtotal");

    for (var i = 0; i < cant.length; i++) {
        var inpS = sub[i];
        document.getElementsByName("subtotal")[i].innerHTML = parseFloat(inpS.textContent).toFixed(2);
    }
    calcularTotales();
}

function calcularTotales() {
    "use strict";
    let sub = document.getElementsByName("subtotal");
    let total = 0.0;

    for (let i = 0; i < sub.length; i++) {
        total += parseFloat(sub[i].textContent);
    }


    $("#amount").val(total.toFixed(2));


    var simbolo = '$';


    $("#total").html(`${simbolo} ${total.toFixed(2)}`);


    $("#subtotal_valor").val(total.toFixed(2));


    $("#most_total").html(`${simbolo} ${total.toFixed(2)}`);

    let tpagado = parseFloat($("#tpagado").val()) || 0;
    let totalvuelto = (tpagado > 0) ? tpagado - total : 0;

    $("#vuelto").html(`${simbolo} ${totalvuelto.toFixed(2)}`);
    $("#cambio").val(totalvuelto || "");

    evaluar(); 

    borrar_filas();
}


function evaluar() {
	if (detalles > 0) {
		$("#btnGuardar").show();
	} else {
		$("#btnGuardar").hide();
		cont = 0;
	}
}


function eliminarDetalle(indice) {
	$("#fila" + indice).remove();
	calcularTotales();
	detalles = detalles - 1;

}


    // Función para buscar clientes
    $('#buscarCliente').on('input', function() {
        var query = $(this).val().trim();
        
        if(query.length >= 2) { 
            $.ajax({
                url: baseUrl+'search/client/payment',
                method: 'POST',
                data: { query: query },
                dataType: 'json',
                    success: function(response) {
						//console.log(response);
                    var resultados = $('#resultadosClientes');
                    resultados.empty();
                    
                    if(response.status && response.clientes.length > 0) {
                        $.each(response.clientes, function(index, cliente) {
                            resultados.append(
                                '<a href="#" class="list-group-item list-group-item-action" ' +
                                'data-id="' + cliente.id + '" ' +
                                'data-nombre="' + cliente.nombre_completo + '">' +
                                cliente.texto_busqueda +
                                '</a>'
                            );
                        });
                        resultados.show();
                    } else {
                        resultados.hide();
                    }
                },
                error: function() {
                    $('#resultadosClientes').hide();
                    console.error('Error en la búsqueda');
                }
            });
        } else {
            $('#resultadosClientes').hide();
            $('#idcliente').val('');
        }
    });
    
    // Seleccionar un cliente de los resultados
    $(document).on('click', '#resultadosClientes a', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        var nombre = $(this).data('nombre');
        
        $('#buscarCliente').val(nombre);
        $('#idcliente').val(id);
        listarLecturas(id);
        $('#resultadosClientes').hide();
    });
    
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#buscarCliente, #resultadosClientes').length) {
            $('#resultadosClientes').hide();
        }
    });
    
    $('#buscarCliente').on('change', function() {
        if($(this).val() === '') {
            $('#idcliente').val('');
        }
    });

init();
