"use strict";
var tabla;

//funcion que se ejecuta al inicio
function init() {
  mostrarAjustes();
  $("#detallesEliminados").hide();

  $("#formulario").on("submit", function (e) {
    guardaryeditar(e);
  });
}

//funcion limpiar
function limpiar() {
  $("#id").val("");
  $("#idMedidor").val("");
  $("#series").val("");
  $("#cliente").val("");
  $("#previus_reading").val("");
  $("#last_reading").val("");
  $("#consumption").val("");
  $("#total_cost").val("");
}

//funcion listar

//funcion para guardaryeditar
function guardaryeditar(e) {
  e.preventDefault(); //no se activara la accion predeterminada
  $("#btnGuardar").prop("disabled", true);
  var formData = new FormData($("#formulario")[0]);

  $.ajax({
    url: baseUrl + "meter-reading/guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,

    success: function (datos) {
      var tabla = $("#tbllistado").DataTable();
      Swal.fire({
        title: "Registro",
        text: datos,
        icon: "info",
        /*buttons: {
          confirm: "OK",
        },*/
      });
      $("#btnGuardar").prop("disabled", false);
    },
  });

  limpiar();
}

function mostrar(id) {
  $.post("meter-reading/mostrar", { id: id }, function (data, status) {
    data = JSON.parse(data);

    $("#id").val(data.id);
    $("#idMedidor").val(data.meter_id);
    if (data.previus_reading == 0) {
      // Si la lectura previa es 0, permite la edición del campo de entrada
      $("#previus_reading").prop("readonly", false);
    } else {
      // Si la lectura previa no es 0, hace que el campo de entrada sea de solo lectura
      $("#previus_reading").prop("readonly", true);
    }
    $("#previus_reading").val(data.previus_reading);
    $("#last_reading").val(data.last_reading);

    $("#total_cost").val(data.total_cost);
    $("#type").val(data.type);
  });
}

//funcion para mostrar formulario paa agregar nuevo cliente
function verMedidores() {
  $("#mdlclientes").modal("show");
  listarClientes();
}

function listarClientes() {
  tabla = $("#tblclientes")
    .dataTable({
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        thousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
      aProcessing: true, //activamos el procedimiento del datatable
      aServerSide: true, //paginacion y filrado realizados por el server
      dom: "Bfrtip", //definimos los elementos del control de la tabla
      buttons: [],
      ajax: {
        url: baseUrl + "meters/listaReading",
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      iDisplayLength: 10, //paginacion
      order: [[0, "desc"]], //ordenar (columna, orden)
    })
    .DataTable();
}

function agregarCliente(id, serie, last_reading, cliente, client_id) {
  limpiar();
  $("#idMedidor").val(id);
  if (last_reading == 0) {
    // Si la lectura previa es 0, permite la edición del campo de entrada
    $("#previus_reading").prop("readonly", false);
  } else {
    // Si la lectura previa no es 0, hace que el campo de entrada sea de solo lectura
    $("#previus_reading").prop("readonly", true);
  }
  $("#previus_reading").val(last_reading);
  $("#series").val(serie);
  $("#cliente").val(cliente);
  $("#client_id").val(client_id);
  $("#mdlclientes").modal("hide");
}

var max_cubic = 0;
var cost_water = 0;
var price_cubic = 0;
var total_cost = 0;
var consumption = 0;
var plus = 0;
var costMeter = 1;

$("#last_reading").change(function () {
  calcularConsumo();
});

$("#type").change(function () {
  calcularConsumo();
});

function mostrarAjustes() {
  $.get(baseUrl + "company/mostrar", function (data, status) {
    data = JSON.parse(data);
    max_cubic = parseFloat(data.max_cubic);
    cost_water = parseFloat(data.cost_water);
    price_cubic = parseFloat(data.price_cubic);
    $("#max_cubico").text(max_cubic);
    $("#precio_fijo").text(cost_water);
    $("#precio_cubico").text(price_cubic);
  });
}

function calcularConsumo() {
  var typeMeter = $("#type").val();
  var adjustedMaxCubic = max_cubic;
  var adjustedCostWater = cost_water;

  if (typeMeter === "Bimestral") {
    adjustedMaxCubic = max_cubic * 2;
    costMeter = 2;
  } else if (typeMeter === "Trimestral") {
    adjustedMaxCubic = max_cubic * 3;
    costMeter = 3;
  } else {
    costMeter = 1;
  }

  $("#max_cubico").text(adjustedMaxCubic);

  var now_reading = parseFloat($("#last_reading").val());
  var previus_reading = parseFloat($("#previus_reading").val());

  if (
    isNaN(now_reading) ||
    isNaN(previus_reading) ||
    now_reading <= previus_reading
  ) {
    Swal.fire(
      "Error",
      "Ingrese valores válidos y asegúrese de que la lectura actual sea mayor que la anterior.",
      "error"
    );
    $("#last_reading").val("");
    return;
  }

  consumption = now_reading - previus_reading;
  $("#consumption").val(consumption);

  if (consumption > adjustedMaxCubic) {
    plus = consumption - adjustedMaxCubic;
    total_cost = adjustedCostWater * costMeter + plus * price_cubic;
  } else {
    total_cost = adjustedCostWater * costMeter;
  }

  $("#total_cost").val(total_cost.toFixed(2));
}

// Crea un nuevo objeto Scanner de Instascan con las configuraciones especificadas
var scanner = new Instascan.Scanner({
  continuous: true, // Escaneo continuo
  video: document.getElementById("preview"), // Elemento de video para mostrar la vista previa del escáner
  mirror: false, // No se refleja la imagen en el escáner
  captureImage: false, // No se captura la imagen
  backgroundScan: false, // No se escanea en segundo plano
  refractoryPeriod: 5000, // Período refractario de 5 segundos
  scanPeriod: 5, // Período de escaneo de 5 milisegundos
});

// Agrega un evento 'scan' al escáner que se activa cuando se escanea un código
scanner.addListener("scan", function (content) {
  // Detener el scanner para evitar múltiples lecturas
  scanner.stop();

  // Realiza una solicitud GET al script PHP para registrar la asistencia con el código escaneado
  $.get(
    baseUrl + "meter-reading/search/meter",
    { codigo: content },
    function (data) {
      try {
        // Parsear los datos JSON primero
        var response = JSON.parse(data);

        // Mostrar la respuesta parseada para debugging (opcional)
        //console.log('Respuesta recibida:', response);

        // Verificar si la búsqueda fue exitosa
        if (response.success) {
          // Si hay datos, procesarlos
          var meterData = response.data;

          // Limpiar campos
          limpiar();

          // Asignar valores a los campos
          $("#idMedidor").val(meterData.id);
          $("#previus_reading").val(meterData.last_reading);
          $("#series").val(meterData.series);
          $("#cliente").val(meterData.client);
          $("#client_id").val(meterData.client_id);

          // Configurar el campo de lectura previa según el valor
          if (meterData.last_reading == 0) {
            $("#previus_reading").prop("readonly", false);
          } else {
            $("#previus_reading").prop("readonly", true);
          }

          // Mostrar mensaje de éxito
          Swal.fire({
            position: "top-end",
            //title: "Éxito",
            text: "Medidor encontrado correctamente",
            icon: "success",
            showConfirmButton: false,
            timer: 1500,
          });

          // Cerrar el modal después de mostrar el resultado
          $("#mdlQRMedidor").modal("hide");
        } else {
          // Si no se encontró el medidor
          Swal.fire({
            title: "Atención",
            text:
              response.message ||
              "No se encontró ningún medidor con este código",
            icon: "warning",
          });
          limpiar();
          // Cerrar el modal
          $("#mdlQRMedidor").modal("hide");
        }
      } catch (error) {
        console.error("Error al parsear JSON:", error);
        console.log("Datos originales:", data);

        Swal.fire({
          title: "Error",
          text: "Error al procesar los datos del medidor",
          icon: "error",
        });

        $("#mdlQRMedidor").modal("hide");
      }
    }
  ).fail(function (xhr, status, error) {
    console.error("Error en la petición:", error);

    Swal.fire({
      title: "Error",
      text: "No se pudo procesar el código QR",
      icon: "error",
    });

    $("#mdlQRMedidor").modal("hide");
  });
});

// Función para iniciar la lectura QR
function iniciarLecturaQr() {
  // Configurar el modal
  $("#mdlQRMedidor").modal({
    backdrop: "static",
    keyboard: false,
  });
  // Mostrar el modal
  $("#mdlQRMedidor").modal("show");
}

// Eventos del modal para manejar la cámara
$("#mdlQRMedidor").on("shown.bs.modal", function () {
  // Iniciar la cámara cuando el modal esté completamente visible
  iniciaCamara();
});

$("#mdlQRMedidor").on("hidden.bs.modal", function () {
  // Asegurar que la cámara se apague cuando el modal se cierre
  apagaCamara();
});

// Función para iniciar la cámara y comenzar a escanear códigos QR
function iniciaCamara() {
  // Obtiene las cámaras disponibles y comienza a escanear utilizando la última cámara encontrada
  Instascan.Camera.getCameras()
    .then(function (cameras) {
      if (cameras.length > 0) {
        scanner.start(cameras[cameras.length - 1]);
      } else {
        Swal.fire({
          title: "Error",
          text: "No se encontró una cámara disponible",
          icon: "error",
        });
        $("#mdlQRMedidor").modal("hide");
      }
    })
    .catch(function (e) {
      console.error(e);
      Swal.fire({
        title: "Error",
        text: "Error al acceder a la cámara: " + e.message,
        icon: "error",
      });
      $("#mdlQRMedidor").modal("hide");
    });
}

// Función para detener el escaneo y apagar la cámara
function apagaCamara() {
  try {
    if (scanner) {
      scanner.stop();
    }
  } catch (e) {
    console.error("Error al detener el scanner:", e);
  }
}

init();
