<!-- Hero Section -->
    <section class="hero-section" id="inicio">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 mb-4">
                    <div class="hero-content">
                        <h1 class="hero-title">Gestión inteligente del agua.</h1>
                        <p class="hero-subtitle">Accede a tu información de pagos, consumos y facturas históricas de manera rápida y segura.</p>
                        <a href="<?php echo $_SERVER['BASE_URL'];?>consulta" class="btn btn-light btn-lg px-4 me-2">
                            <i class="fas fa-search me-2"></i>Consultar ahora
                        </a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <img src="<?php echo $_SERVER['BASE_URL'];?>assets/img/landing/agua3.jpg" 
                         alt="Sistema de gestión de agua" class="img-fluid rounded-3 shadow">
                </div>
            </div>
        </div>
    </section>

<!-- Features Section -->
<section class="features-section py-5 bg-light">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 text-center">
                <h2 class="section-title display-5 fw-bold">Nuestros Servicios</h2>
                <p class="section-subtitle text-muted">Ofrecemos soluciones integrales para tu suministro de agua</p>
            </div>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                         <div class="icon-container d-flex align-items-center justify-content-center mx-auto mb-4">
                    <div class="bg-primary bg-gradient text-white rounded-circle p-3 d-flex align-items-center justify-content-center" 
                         style="width: 64px; height: 64px;">
                        <i class="fas fa-tint fa-2x"></i>
                    </div>
                </div>
                        <h3 class="h4">Suministro Continuo</h3>
                        <p class="text-muted">Garantizamos un suministro de agua potable las 24 horas del día, los 365 días del año.</p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                         <div class="icon-container d-flex align-items-center justify-content-center mx-auto mb-4">
                    <div class="bg-success bg-gradient text-white rounded-circle p-3 d-flex align-items-center justify-content-center" 
                         style="width: 64px; height: 64px;">
                         <i class="fas fa-chart-line fa-2x"></i>
                    </div>
                </div>
                        <h3 class="h4">Monitoreo en Tiempo Real</h3>
                        <p class="text-muted">Sistema de telemetría para monitorear tu consumo y detectar anomalías.</p>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body text-center p-4">
                                                 <div class="icon-container d-flex align-items-center justify-content-center mx-auto mb-4">
                    <div class="bg-info bg-gradient text-white rounded-circle p-3 d-flex align-items-center justify-content-center" 
                         style="width: 64px; height: 64px;">
                         <i class="fas fa-tools fa-2x"></i>
                    </div>
                </div>
                        <h3 class="h4">Mantenimiento Preventivo</h3>
                        <p class="text-muted">Programas de mantenimiento para garantizar la calidad del agua y la infraestructura.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="stats-section py-5 bg-primary text-white">
    <div class="container">
        <div class="row text-center g-4">
            <div class="col-md-3">
                <div class="p-3">
                    <h2 class="display-4 fw-bold">15,000+</h2>
                    <p class="mb-0">Clientes satisfechos</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="p-3">
                    <h2 class="display-4 fw-bold">99.7%</h2>
                    <p class="mb-0">Cobertura de servicio</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="p-3">
                    <h2 class="display-4 fw-bold">24/7</h2>
                    <p class="mb-0">Atención al cliente</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="p-3">
                    <h2 class="display-4 fw-bold">100%</h2>
                    <p class="mb-0">Agua potable certificada</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Water Saving Tips -->
<section class="tips-section py-5" id="consejos">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-4 mb-lg-0">
                <img src="<?php echo $_SERVER['BASE_URL'];?>assets/img/landing/agua2.jpg" 
                     alt="Consejos para ahorrar agua" class="img-fluid rounded-3 shadow">
            </div>
            <div class="col-lg-6">
                <h2 class="display-5 fw-bold mb-4">Consejos para ahorrar agua</h2>
                <div class="accordion" id="tipsAccordion">
                    <div class="accordion-item mb-3 border-0 shadow-sm">
                        <h3 class="accordion-header" id="headingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne">
                                <i class="fas fa-shower me-3 text-primary"></i> En la ducha
                            </button>
                        </h3>
                        <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#tipsAccordion">
                            <div class="accordion-body">
                                Reduce el tiempo de ducha a 5 minutos. Una ducha de 10 minutos consume aproximadamente 200 litros de agua.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item mb-3 border-0 shadow-sm">
                        <h3 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo">
                                <i class="fas fa-utensils me-3 text-primary"></i> En la cocina
                            </button>
                        </h3>
                        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#tipsAccordion">
                            <div class="accordion-body">
                                Lava frutas y verduras en un recipiente y no bajo el chorro de agua. Reutiliza esta agua para regar plantas.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item border-0 shadow-sm">
                        <h3 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree">
                                <i class="fas fa-leaf me-3 text-primary"></i> En el jardín
                            </button>
                        </h3>
                        <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#tipsAccordion">
                            <div class="accordion-body">
                                Riega al amanecer o atardecer para evitar evaporación. Usa sistemas de riego por goteo que son más eficientes.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="faq-section py-5 bg-light" id="faq">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 text-center">
                <h2 class="section-title display-5 fw-bold">Preguntas Frecuentes</h2>
                <p class="section-subtitle text-muted">Encuentra respuestas a las dudas más comunes</p>
            </div>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="accordion" id="faqAccordion">
                    <div class="accordion-item mb-3 border-0 shadow-sm">
                        <h3 class="accordion-header" id="faqHeadingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapseOne">
                                1. ¿Cómo leer mi medidor correctamente?
                            </button>
                        </h3>
                        <div id="faqCollapseOne" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                El medidor muestra tu consumo en metros cúbicos (m³). Registra solo los números negros (ignora los rojos o decimales). Anota este número cada mes para comparar con tu factura.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item mb-3 border-0 shadow-sm">
                        <h3 class="accordion-header" id="faqHeadingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapseTwo">
                                2. ¿Qué hago si mi factura parece incorrecta?
                            </button>
                        </h3>
                        <div id="faqCollapseTwo" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Si notas una discrepancia en tu factura, por favor contáctanos dentro de los 5 días hábiles después de recibida la factura con una foto de tu medidor actual para revisión.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item mb-3 border-0 shadow-sm">
                        <h3 class="accordion-header" id="faqHeadingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapseThree">
                                3. ¿Dónde puedo realizar mis pagos?
                            </button>
                        </h3>
                        <div id="faqCollapseThree" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Puedes pagar en nuestras oficinas, bancos asociados o mediante transferencia bancaria.
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item border-0 shadow-sm">
                        <h3 class="accordion-header" id="faqHeadingFour">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faqCollapseFour">
                                4. ¿Cómo reportar una fuga o emergencia?
                            </button>
                        </h3>
                        <div id="faqCollapseFour" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                Para emergencias las 24 horas, llama al (123) 456-7890 o envía un WhatsApp al 0991234567 con tu dirección y fotos del problema.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Contact Section -->
<!--<section class="contact-section py-5" id="contacto">
    <div class="container">
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 text-center">
                <h2 class="section-title display-5 fw-bold">Contáctanos</h2>
                <p class="section-subtitle text-muted">Estamos aquí para ayudarte con cualquier consulta</p>
            </div>
        </div>
        
        <div class="row g-4">
            <div class="col-md-6">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body p-4">
                        <h3 class="h4 mb-4">Información de contacto</h3>
                        <ul class="list-unstyled">
                            <li class="mb-3">
                                <i class="fas fa-map-marker-alt text-primary me-3"></i>
                                Av. Principal 123, Ciudad
                            </li>
                            <li class="mb-3">
                                <i class="fas fa-phone-alt text-primary me-3"></i>
                                (123) 456-7890
                            </li>
                            <li class="mb-3">
                                <i class="fas fa-envelope text-primary me-3"></i>
                                info@servicioagua.com
                            </li>
                            <li class="mb-3">
                                <i class="fas fa-clock text-primary me-3"></i>
                                Lunes a Viernes: 8:00 AM - 5:00 PM
                            </li>
                        </ul>
                        
                        <div class="social-icons mt-4">
                            <a href="#" class="text-decoration-none me-3"><i class="fab fa-facebook-f fa-lg"></i></a>
                            <a href="#" class="text-decoration-none me-3"><i class="fab fa-twitter fa-lg"></i></a>
                            <a href="#" class="text-decoration-none me-3"><i class="fab fa-instagram fa-lg"></i></a>
                            <a href="#" class="text-decoration-none"><i class="fab fa-whatsapp fa-lg"></i></a>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-4">
                        <h3 class="h4 mb-4">Envíanos un mensaje</h3>
                        <form>
                            <div class="mb-3">
                                <label for="name" class="form-label">Nombre completo</label>
                                <input type="text" class="form-control" id="name" required>
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label">Correo electrónico</label>
                                <input type="email" class="form-control" id="email" required>
                            </div>
                            <div class="mb-3">
                                <label for="subject" class="form-label">Asunto</label>
                                <input type="text" class="form-control" id="subject" required>
                            </div>
                            <div class="mb-3">
                                <label for="message" class="form-label">Mensaje</label>
                                <textarea class="form-control" id="message" rows="4" required></textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">Enviar mensaje</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>-->

<!-- Map Section -->
<!--<section class="map-section">
    <div class="container-fluid p-0">
        <div class="ratio ratio-21x9">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3989.654345654345!2d-78.45678901234567!3d-0.12345678901234567!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMMKwMDcnMjQuNSJTIDc4wrAyNyczNi4xIlc!5e0!3m2!1ses!2sec!4v1234567890123!5m2!1ses!2sec" 
                    allowfullscreen="" loading="lazy" class="border-0"></iframe>
        </div>
    </div>
</section>-->