"use strict";
function init() {
	cuadros1();
	egreso12meses();
	ingreso12meses();
}

function cuadros1() {
	$.get("dashboard/cuadros1", function (data, status) {
		data = JSON.parse(data);
		//INGRESOS
		$("#totalIncomes").html(data.totalIncomes);
		//EGRESOS
		$("#totalExpenses").html(data.totalExpenses);
		//CLIENTES
		$("#cantidadclientes").html(data.cantidadclientes);
		//MEDIDORES
		$("#cantidadMedidores").html(data.cantidadMedidores);
	});
}

//INGRESOS DE LOS ULTIMOS 12 MESES
function ingreso12meses() {
	$.get("dashboard/ingresos12meses", function (data, status) {
		data = JSON.parse(data);
		var ctx = document.getElementById("ingreso12meses").getContext("2d");
		var myChart = new Chart(ctx, {
			type: "bar",
			data: {
				labels: data.fechas,
				datasets: [
					{
						label: "Ingresos",
						data: data.totales,
						//borderWidth: 2,
						backgroundColor: [
							"#fc544b",
							"#F4D03F",
							"#63ed7a",
							"#1262F7",
							"#ffa426",
							"#6777ef",
							"#fc544b",
							"#F4D03F",
							"#63ed7a",
							"#1262F7",
							"#ffa426",
							"#6777ef",
						],
						//borderColor: "#6777ef",
						//borderWidth: 2.5,
						//pointBackgroundColor: "#ffffff",
						//pointRadius: 4,
					},
				],
			},
			options: {
				legend: {
					display: true,
				},
				scales: {
					yAxes: [
						{
							gridLines: {
								drawBorder: true,
								color: "#f2f2f2",
							},
							ticks: {
								beginAtZero: true,
								stepSize: 5000,
								fontColor: "#9aa0ac", // Font Color
							},
						},
					],
					xAxes: [
						{
							ticks: {
								display: true,
							},
							gridLines: {
								display: true,
							},
						},
					],
				},
			},
		});
	});
}

//EGRESOS DE LOS ULTIMOS 12 MESES
function egreso12meses() {
	$.get("dashboard/egresos12meses", function (data, status) {
		data = JSON.parse(data);
		var ctx = document.getElementById("egreso12meses").getContext("2d");
		var myChart = new Chart(ctx, {
			type: "bar",
			data: {
				labels: data.fechas,
				datasets: [
					{
						label: "Egresos",
						data: data.totales,
						//borderWidth: 2,
						backgroundColor: [
							"#1262F7",
							"#fc544b",
							"#F4D03F",
							"#63ed7a",
							"#1262F7",
							"#ffa426",
							"#6777ef",
							"#fc544b",
							"#F4D03F",
							"#63ed7a",
							"#ffa426",
							"#6777ef",
						],
						//borderColor: "#6777ef",
						//borderWidth: 2.5,
						//pointBackgroundColor: "#ffffff",
						//pointRadius: 4,
					},
				],
			},
			options: {
				legend: {
					display: true,
				},
				scales: {
					yAxes: [
						{
							gridLines: {
								drawBorder: true,
								color: "#f2f2f2",
							},
							ticks: {
								beginAtZero: true,
								stepSize: 5000,
								fontColor: "#9aa0ac", // Font Color
							},
						},
					],
					xAxes: [
						{
							ticks: {
								display: true,
							},
							gridLines: {
								display: true,
							},
						},
					],
				},
			},
		});
	});
}

init();
