<div class="page-content">
    <section class="section">
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <!-- Título y controles principales -->
                            <div class="d-flex flex-column flex-lg-row justify-content-between align-items-start align-items-lg-center gap-3 mb-3">
                                <h4 class="card-title mb-0">Lista de asistencias</h4>

                                <!-- Controles de la derecha en desktop -->
                                <div class="d-flex flex-column flex-sm-row gap-2 align-items-start align-items-sm-center">
                                    <span class="text-muted small">Registro general:</span>
                                    <div class="d-flex gap-2">
                                        <button id="btnAsistencia" <?php if ($status) {
                                                                        echo '';
                                                                    } else {
                                                                        echo 'disabled';
                                                                    } ?>
                                            class="btn btn-success" onclick="registerAll(<?php echo $id; ?>, '1')">
                                            <i class="bi bi-clipboard2-check"></i>
                                            <span class="d-none d-sm-inline">Asistencia</span>
                                        </button>
                                        <button id="btnFalta" <?php if ($status) {
                                                                    echo '';
                                                                } else {
                                                                    echo 'disabled';
                                                                } ?>
                                            class="btn btn-danger" onclick="registerAll(<?php echo $id; ?>, '0')">
                                            <i class="bi bi-clipboard2-x"></i>
                                            <span class="d-none d-sm-inline">Falta</span>
                                        </button>
                                        <a href="<?php echo $_SERVER['BASE_URL']; ?>meetings" class="btn btn-outline-primary">
                                            <i class="bi bi-calendar3"></i>
                                            <span class="d-none d-sm-inline">Reuniones</span>
                                        </a>
                                    </div>
                                </div>
                            </div>

                            <!-- Controles de filtro y acciones -->
                            <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-3">
                                <!-- Selector de barrio -->
                                <div class="d-flex flex-column flex-sm-row align-items-start align-items-sm-center gap-2">
                                    <input type="hidden" value="<?php echo $id; ?>" id="id">
                                    <label for="zone_id" class="form-label mb-0 text-nowrap">Barrio:</label>
                                    <select name="zone_id" id="zone_id" class="form-select form-select" style="min-width: 200px;">
                                        <option value="" selected disabled>Seleccionar barrio</option>
                                        <?php foreach ($zones as $zone): ?>
                                            <option value="<?php echo htmlspecialchars($zone['id']); ?>">
                                                <?php echo htmlspecialchars($zone['name']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <!-- Botón QR -->
                                <div class="align-self-stretch align-self-md-auto">
                                    <button class="btn btn-info w-100 w-md-auto" type="button" onclick="iniciarLecturaQr()">
                                        <i class="fa fa-qrcode me-1"></i>
                                        <span>Asistencia QR</span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!--TABLA DE LISTADO DE REGISTROS-->
                        <div class="card-body">
                            <div class="table-responsive" id="listadoregistros">
                                <table id="tbllistado" class="table table-striped table-hover text-nowrap"
                                    style="width:100%;">
                                    <thead>
                                        <th>Socio</th>
                                        <th>Documento</th>
                                        <th>Teléfono</th>
                                        <th>Estado</th>
                                        <th>Registrar</th>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                    <tfoot>
                                        <th>Socio</th>
                                        <th>Documento</th>
                                        <th>Teléfono</th>
                                        <th>Estado</th>
                                        <th>Registrar</th>
                                    </tfoot>
                                </table>
                            </div>
                            <!--TABLA DE LISTADO DE REGISTROS FIN-->

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
</div>

<!-- Modal para escanear QR -->
<div class="modal fade" id="mdlQRSocio" tabindex="-1" role="dialog" aria-labelledby="qrModalLabel" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="qrModalLabel">
                    <i class="fa fa-qrcode mr-2"></i>Escaneo de Código QR
                </h5>
            </div>
            <div class="modal-body">
                <div class="row justify-content-center">
                    <div class="col-md-8 text-center">
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle mr-2"></i>Encuadre el código QR del medidor dentro del área delimitada
                        </div>

                        <div class="border border-primary p-2 rounded" style="background-color: #f8f9fa;">
                            <video id="preview" class="w-100" style="max-height: 400px;"></video>
                        </div>

                        <div class="mt-3">
                            <button type="button" id="btnApagaCamara" onclick="$('#mdlQRSocio').modal('hide')" class="btn btn-warning">
                                <i class="fa fa-power-off mr-1"></i> Apagar Cámara
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>